<?php
require_once __DIR__.'/../core/DB.php';
$db = new DB();

$slug = $_GET['slug'] ?? '';
$post = $db->query("SELECT * FROM posts WHERE BINARY slug = ?", [$slug])->fetch();

if (!$post) {
    header("HTTP/1.1 404 Not Found");
    die("<h1>Post not found</h1><p>Slug: $slug doesn't exist.</p>");
}

// Get all columns to display custom fields
$columns = $db->query("SHOW COLUMNS FROM posts")->fetchAll();
$reserved = ['id', 'slug', 'created_at'];
?>
<!DOCTYPE html>
<html data-theme="light">
<head>
    <title><?= htmlspecialchars($post['title']) ?></title>
    <style>
        .custom-field {
            margin: 1.5rem 0;
            padding: 1rem;
            border-left: 3px solid #3498db;
            background: #f8f9fa;
        }
        .error { color: red; }
    </style>
</head>
<body>
<article>
    <h1><?= htmlspecialchars($post['title']) ?></h1>

    <!-- Main Content -->
    <div class="content">
        <?= nl2br(htmlspecialchars($post['content'] ?? '')) ?>
    </div>

    <!-- Custom Fields -->
    <?php foreach ($columns as $col): ?>
        <?php
        $field = $col['Field'];
        if (!in_array($field, $reserved) && isset($post[$field]) && $post[$field] !== null):
            ?>
            <div class="custom-field">
                <h3><?= ucwords(str_replace('_', ' ', $field)) ?></h3>
                <?php if ($col['Type'] === 'longtext'): ?>
                    <?= nl2br(htmlspecialchars($post[$field])) ?>
                <?php else: ?>
                    <?= htmlspecialchars($post[$field]) ?>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    <?php endforeach; ?>
</article>
</body>
</html>